/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.InnerSlopedPrismSkipPredicate;

public final class InnerPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        if (side.m_122434_() != axis) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (axis == dir.m_122434_()) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_INNER_PRISM -> InnerPrismSkipPredicate.testAgainstInnerPrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_INNER_SLOPED_PRISM -> InnerPrismSkipPredicate.testAgainstInnerSlopedPrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM -> InnerPrismSkipPredicate.testAgainstDoublePrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPED_PRISM -> InnerPrismSkipPredicate.testAgainstDoubleSlopedPrism(level, pos, state, dir, axis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstInnerPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction.Axis adjAxis = (Direction.Axis)adjState.m_61143_((Property)BlockStateProperties.f_61365_);
        if (InnerPrismSkipPredicate.getTriDir(dir, axis, side).isEqualTo(InnerPrismSkipPredicate.getTriDir(adjDir, adjAxis, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction adjOrientation = (Direction)adjState.m_61143_((Property)PropertyHolder.ORIENTATION);
        if (InnerPrismSkipPredicate.getTriDir(dir, axis, side).isEqualTo(InnerSlopedPrismSkipPredicate.getTriDir(adjDir, adjOrientation, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerPrismSkipPredicate.testAgainstInnerPrism(level, pos, state, dir, axis, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstDoubleSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerPrismSkipPredicate.testAgainstInnerSlopedPrism(level, pos, state, dir, axis, (BlockState)states.m_14418_(), side);
    }

    public static HalfDir getTriDir(Direction dir, Direction.Axis axis, Direction side) {
        if (dir.m_122434_() != axis && side.m_122434_() == axis) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

